def parse_bedgraph(filepath, strand):
    """ Reads a file in the bedgraph format
    and stores each value in a nested dictionary """
    
    if strand not in ['+','-','.']:
        print("ERROR: strand must be + - or .")
        return
    
    coverage_dict = {}
    coverage_dict['+'] = {}
    coverage_dict['-'] = {}
    coverage_dict['.'] = {}
    
    coverage_file = open(filepath)
    
    for line in coverage_file:
        if line[0] == '#':
            continue
        l = line.rstrip().split()
        chrom = l[0]
        start = int(l[1])
        end = int(l[2])
        value = float(l[3])
        
        if value == 0:
            continue
        
        if chrom not in coverage_dict[strand]:
            coverage_dict[strand][chrom] = {}
        
        for pos in range(start, end):
            coverage_dict[strand][chrom][pos] = \
                coverage_dict[strand][chrom].get(pos,float(0)) + value
    
    coverage_file.close()
    return coverage_dict


def add_bedgraph(coverage_dict, filepath, strand):
    """ Adds a new bedgraph file to an existing
    coverage_dict generated by parse_bedgraph """
    
    coverage_file = open(filepath)
    
    for line in coverage_file:
        if line[0] == '#':
            continue
        l = line.rstrip().split()
        chrom = l[0]
        start = int(l[1])
        end = int(l[2])
        value = float(l[3])
        
        if value == 0:
            continue
        
        if chrom not in coverage_dict[strand]:
            coverage_dict[strand][chrom] = {}
        
        for pos in range(start, end):
            coverage_dict[strand][chrom][pos] = \
                coverage_dict[strand][chrom].get(pos,float(0)) + value
    
    coverage_file.close()
    

def parse_multi_bedgraph(filepath, strand, multi_key):
    """ Reads a file in the multi-column bedgraph format
    and stores each value in a nested dictionary """
    
    if strand not in ['+','-','.']:
        print("ERROR: strand must be + - or .")
        return
    
    coverage_dict = {}
    coverage_dict['+'] = {}
    coverage_dict['-'] = {}
    coverage_dict['.'] = {}
    
    coverage_file = open(filepath)
    
    for line in input_file:
        if line[0] == '#':
            continue
        l = line.rstrip().split()
        chrom = l[0]
        start = int(l[1])
        end = int(l[2])
        countvals = [float(i) for i in l[3:]]
        
        if chrom not in coverage_dict[strand]:
            coverage_dict[strand][chrom] = {}
        
        for pos in range(start, end):
            for i in range(len(multikey)):
                if countvals[i] > 0:
                    if pos not in coverage_dict[s][chrom]:
                        coverage_dict[s][chrom][pos] = {}
                    coverage_dict[s][chrom][pos][multikey[i]] = UNTEMP[s][chrom][pos].get(multikey[i],0) + countvals[i]
    
    input_file.close()
    return coverage_dict    


def add_multi_bedgraph(coverage_dict, filepath, strand, multi_key):
    """ Adds a new bedgraph file to an existing
    coverage_dict generated by parse_multi_bedgraph """
    
    coverage_file = open(filepath)
    
    for line in coverage_file:
        if line[0] == '#':
            continue
        l = line.rstrip().split()
        chrom = l[0]
        start = int(l[1])
        end = int(l[2])
        countvals = [float(i) for i in l[3:]]
        
        if chrom not in coverage_dict[strand]:
            coverage_dict[strand][chrom] = {}
        
        for pos in range(start, end):
            for i in range(len(multikey)):
                if countvals[i] > 0:
                    if pos not in coverage_dict[s][chrom]:
                        coverage_dict[s][chrom][pos] = {}
                    coverage_dict[s][chrom][pos][multikey[i]] = UNTEMP[s][chrom][pos].get(multikey[i],0) + countvals[i]
    
    coverage_file.close()

