#!/bin/bash

### ENVIRONMENT PARAMETERS ###
PBS_P='rnaseq_nod'
PBS_q='workq'
root_dir=/lustre/scratch/users/$USER/EndGraph
genome_dir=/lustre/scratch/users/$USER/genome
resource_dir=$root_dir/resources
log_dir=$root_dir/log

reference_table=$resource_dir/reference_table_EndMask.txt
genome_fasta=$genome_dir/TAIR10_ERCC.fas
annotation_gff=$genome_dir/TAIR10_ERCC.gff
annotation_subset=$genome_dir/pc_teg_other_ercc.txt

number_of_jobs=$(wc -l $reference_table | cut -f1 -d' ')
walltime="4:00:00"
CPUS=4
RAM=20

environment_variables="root_dir=$root_dir"
if [ $number_of_jobs -eq 1 ]
then
  SAMPLEJOBS=""
  environment_variables+=",JOB_NUMBER=1"
else
  SAMPLEJOBS="-J 1-$number_of_jobs"
fi

environment_variables+=",reference_table=$reference_table"
environment_variables+=",genome_fasta=$genome_fasta"
environment_variables+=",annotation_gff=$annotation_gff"
environment_variables+=",annotation_subset=$annotation_subset"
environment_variables+=",LMOD=1"
environment_variables+=",CPUS=$CPUS"

PBS_OPTIONS="-P $PBS_P \
-q $PBS_q \
-N endmask \
$SAMPLEJOBS \
-v $environment_variables \
-j oe \
-o $log_dir/EndMask/^array_index^_endmask.log \
-l select=1:ncpus="$CPUS":mem="$RAM"gb \
-l walltime=$walltime"

job_description="qsub $PBS_OPTIONS $root_dir/endMask.sh"

echo $job_description
eval $job_description

echo "EndMask job submitted."
