
library(edgeR)

### make files
dat<- read.table("real.txt", header=TRUE, sep="\t", strip.white=TRUE,row.names=1)
group=factor(c(
"group1",
"group1",
"group2",
"group2"
))

dgList <- DGEList(counts=dat, group=group)
l <- nrow(dat)

### check rows
head(dgList$counts) #Many rows!
head(dgList$genes) #Likewise!

### get cpm
### filter low input
keep <- rowSums(cpm(dgList)) >= 2
dgList <- dgList[keep,]
dim(dgList)
##recompute library sizes
dgList$samples$lib.size <- colSums(dgList$counts)
dgList$samples


### normilize
dgList <- calcNormFactors(dgList, method="TMM")

### plotMDS
plotMDS(dgList)



#estimate dispersion
dgList <- estimateCommonDisp(dgList)
dgList <- estimateTagwiseDisp(dgList)
plotBCV(dgList)

#test for DE
et <- exactTest(dgList)
top <- topTags(et,n=l)
#total number of genes at 5% FDR
summary(de <- decideTestsDGE(et))
lst <-cpm(dgList)[rownames(de), ]

write.table(lst, file="TMM-normalized.txt",col.names=TRUE,sep="\t",quote=F,append=FALSE)
write.table(top, file="pvals.txt",col.names=TRUE,sep="\t",quote=F,append=FALSE)
#move column headers one column to the right (inapproporiate format due to as.matrix)

detags <- rownames(dgList)[as.logical(de)]
plotSmear(et, de.tags=detags)
abline(h=c(-1, 1), col="blue")



