#!/bin/sh

#SBATCH --mail-user=kecostello@coh.org
#SBATCH -n 1
#SBATCH -N 1-1
#SBATCH --mem=100G
#SBATCH --time=01:00:00
#SBATCH --output=coverage-out.log

Chimera_bed=$3
sample=`pwd`
name=`basename $sample`

module load bedtools
    bamToBed -split -i $name-sorted-accepted_hits.bam >$name\.bed
    coverageBed -counts  -b $name\.bed -a $Chimera_bed > $2-$name-counts.bed ; echo "coverage done"
    awk '{print $1":"$2"-"$3":"$5"\t"$6 }' $2-$name-counts.bed | sort -k1,1 > $2-$name-norm.counts ; echo "sort done"
    rm $2-$name-counts.bed 

echo "And Rohan will answer" >> $1

