
dgList <- DGEList(counts=dat, group=group)
l <- nrow(dat)

### get cpm
### filter low input
keep <- rowSums(cpm(dgList)) >= 3
dgList <- dgList[keep,]
dim(dgList)
##recompute library sizes
dgList$samples$lib.size <- colSums(dgList$counts)
#dgList$samples

### normilize
dgList <- calcNormFactors(dgList, method="TMM")

### plotMDS
pdf("MDS.pdf")
plotMDS(dgList)
dev.off()


#estimate dispersion
dgList <- estimateCommonDisp(dgList)
dgList <- estimateTagwiseDisp(dgList)
pdf("BCV.pdf")
plotBCV(dgList)
dev.off()

#test for DE
et <- exactTest(dgList)
top <- topTags(et,n=l)
#total number of genes at 5% FDR
summary(de <- decideTestsDGE(et))
lst <-cpm(dgList)[rownames(de), ]

write.table(lst, file="TMM-normalized.txt",col.names=TRUE,sep="\t",quote=F,append=FALSE)
write.table(top, file="pvals.txt",col.names=TRUE,sep="\t",quote=F,append=FALSE)
#move column headers one column to the right (inapproporiate format due to as.matrix)

pdf("Smear.pdf")
detags <- rownames(dgList)[as.logical(de)]
plotSmear(et, de.tags=detags)
abline(h=c(-1, 1), col="blue")
dev.off()

