#!/bin/sh

#$dir/scripts/STAR.sh $file $name $dir/projects/$project/run-space/signal-flare-bam $dir/Reference/$species/$species\_STAR $dir/Reference/$species/$species.$geneDataBase.gtf $foo $STAR $nodes
read1=$1
name=$2
REFERENCE=$4
gtf=$5
compression=$6
STAR=$7
nodes=$8

if [[ $compression == ".gz" ]] ; then

$STAR --runThreadN $nodes --outFileNamePrefix $name --outSAMtype BAM Unsorted --sjdbGTFfile $gtf --outFilterMultimapNmax 100 --winAnchorMultimapNmax 100 --outFilterScoreMinOverLread 0.4 --outFilterMatchNminOverLread 0.4 --genomeDir $REFERENCE --readFilesIn $read1 --outSAMattributes All --outSAMstrandField intronMotif --outSAMattrIHstart 0 --readFilesCommand zcat

fi
if [[ $compression == ".bz2" ]] ; then

$STAR --runThreadN $nodes --outFileNamePrefix $name --outSAMtype BAM Unsorted --sjdbGTFfile $gtf --outFilterMultimapNmax 100 --winAnchorMultimapNmax 100 --outFilterScoreMinOverLread 0.4 --outFilterMatchNminOverLread 0.4 --genomeDir $REFERENCE --readFilesIn $read1 --outSAMattributes All --outSAMstrandField intronMotif --outSAMattrIHstart 0 --readFilesCommand bzcat

fi
if [[ $compression == ".fastq" ]] ; then

$STAR --runThreadN $nodes --outFileNamePrefix $name --outSAMtype BAM Unsorted --sjdbGTFfile $gtf --outFilterMultimapNmax 100 --winAnchorMultimapNmax 100 --outFilterScoreMinOverLread 0.4 --outFilterMatchNminOverLread 0.4 --genomeDir $REFERENCE --readFilesIn $read1 --outSAMattributes All --outSAMstrandField intronMotif --outSAMattrIHstart 0

fi


echo "done `date`" >> $3


