#!/bin/sh

#$dir/scripts/STAR.sh $file $file2 $name $dir/projects/$project/run-space/signal-flare-bam $dir/Reference/$species/$species\_STAR $dir/Reference/$species/$species.$geneDataBase.gtf $foo $STAR $nodes

read1=$1
read2=$2
name=$3
REFERENCE=$5
gtf=$6
compression=$7
STAR=$8
nodes=$9

if [[ $compression == "gz" ]] ; then

$STAR --runThreadN $nodes --outFileNamePrefix $name --outSAMtype BAM SortedByCoordinate --sjdbGTFfile $gtf --outFilterMultimapNmax 100 --winAnchorMultimapNmax 100 --outFilterScoreMinOverLread 0.4 --outFilterMatchNminOverLread 0.4 --genomeDir $REFERENCE --readFilesIn $read1 $read2 --outSAMattributes All --outSAMstrandField intronMotif --outSAMattrIHstart 0 --readFilesCommand zcat

fi
if [[ $compression == "bz2" ]] ; then

$STAR --runThreadN $nodes --outFileNamePrefix $name --outSAMtype BAM SortedByCoordinate --sjdbGTFfile $gtf --outFilterMultimapNmax 100 --winAnchorMultimapNmax 100 --outFilterScoreMinOverLread 0.4 --outFilterMatchNminOverLread 0.4 --genomeDir $REFERENCE --readFilesIn $read1 $read2 --outSAMattributes All --outSAMstrandField intronMotif --outSAMattrIHstart 0 --readFilesCommand bzcat

fi
if [[ $compression == "fastq" ]] ; then
# normal star #
#$STAR --runThreadN $nodes --outFileNamePrefix $name --outSAMtype BAM SortedByCoordinate --sjdbGTFfile $gtf --genomeDir $REFERENCE --readFilesIn $read1 $read2 --outSAMattributes All --outSAMstrandField intronMotif --outSAMattrIHstart 0
## multimapping ##
$STAR --runThreadN $nodes --outFileNamePrefix $name --outSAMtype BAM SortedByCoordinate --sjdbGTFfile $gtf --outFilterMultimapNmax 100 --winAnchorMultimapNmax 100 --outFilterScoreMinOverLread 0.4 --outFilterMatchNminOverLread 0.4 --genomeDir $REFERENCE --readFilesIn $read1 $read2 --outSAMattributes All --outSAMstrandField intronMotif --outSAMattrIHstart 0

fi

echo "done `date`" >> $4

