% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrinucleotideMatrix.R
\name{trinucleotideMatrix}
\alias{trinucleotideMatrix}
\title{Extract single 5' and 3' bases flanking the mutated site for de-novo signature analysis. Also estimates APOBEC enrichment scores.}
\usage{
trinucleotideMatrix(maf, ref_genome, prefix = NULL, add = TRUE,
  ignoreChr = NULL, useSyn = TRUE, fn = NULL)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{ref_genome}{faidx indexed refrence fasta file.}

\item{prefix}{Prefix to add or remove from contig names in MAF file.}

\item{add}{If prefix is used, default is to add prefix to contig names in MAF file. If false prefix will be removed from contig names.}

\item{ignoreChr}{Chromsomes to remove from analysis. e.g. chrM}

\item{useSyn}{Logical. Whether to include synonymous variants in analysis. Defaults to TRUE}

\item{fn}{If given writes APOBEC results to an output file with basename fn. Default NULL.}
}
\value{
list of 2. A matrix of dimension nx96, where n is the number of samples in the MAF and a table describing APOBEC enrichment per sample.
}
\description{
Extract single 5' and 3' bases flanking the mutated site for de-novo signature analysis. Also estimates APOBEC enrichment scores.
}
\details{
Extracts immediate 5' and 3' bases flanking the mutated site and classifies them into 96 substitution classes.
This function loads reference genome into memeory. Typical human geneome occupies a peak memory of ~3 gb while extracting bases.

APOBEC Enrichment: Enrichment score is calculated using the same method described by Roberts et al.

                E = (n_tcw * background_c) / (n_C * background_tcw)

 where, n_tcw = number of mutations within T[C>T]W and T[C>G]W context. (W -> A or T)

        n_C   = number of mutated C and G

        background_C and background_tcw motifs are number of C and TCW motifs occuring around +/- 20bp of each mutation.

One-sided Fisher's Exact test is performed to determine the enrichment of APOBEC tcw mutations over background.
}
\examples{
\dontrun{
laml.tnm <- trinucleotideMatrix(maf = laml, ref_genome = 'hg19.fa',
prefix = 'chr', add = TRUE, useSyn = TRUE)
}

}
\references{
Roberts SA, Lawrence MS, Klimczak LJ, et al. An APOBEC Cytidine Deaminase Mutagenesis Pattern is Widespread in Human Cancers. Nature genetics. 2013;45(9):970-976. doi:10.1038/ng.2702.
}
\seealso{
\code{\link{extractSignatures}} \code{\link{plotApobecDiff}}
}
