% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcgacompare.R
\name{tcgaCompare}
\alias{tcgaCompare}
\title{Compare mutation load against TCGA cohorts}
\usage{
tcgaCompare(maf, capture_size = NULL, cohortName = NULL,
  primarySite = FALSE, col = c("gray70", "black"), medianCol = "red",
  fn = NULL, width = 8, height = 5, fontSize = 10)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{capture_size}{capture size for input MAF in MBs. Default NULL. If provided plot will be scaled to mutations per mb. TCGA capture size is assumed to be 50mb.}

\item{cohortName}{name for the input MAF cohort. Default "Input"}

\item{primarySite}{If TRUE uses primary site of cancer as labels instead of TCGA project IDs. Default FALSE.}

\item{col}{color vector for length 2 TCGA cohorts and input MAF cohort. Default gray70 and black.}

\item{medianCol}{color for median line. Default red.}

\item{fn}{If provided saves plot to output pdf with basename fn. Default NULL.}

\item{width}{width for output plot}

\item{height}{height of output plot}

\item{fontSize}{base fontsize. Default 10.}
}
\value{
ggplot object
}
\description{
Compares mutation load in input MAF against all of 33 TCGA cohorts
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
tcgaCompare(maf = laml, cohortName = "AML")
}
