% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/somaticInteractions.R
\name{somaticInteractions}
\alias{somaticInteractions}
\title{Exact tests to detect mutually exclusive, co-occuring and altered genesets.}
\usage{
somaticInteractions(maf, top = 25, genes = NULL, pvalue = c(0.05, 0.01),
  returnAll = FALSE, findPathways = TRUE, kMax = 3, fontSize = 0.8,
  verbose = TRUE)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{top}{check for interactions among top 'n' number of genes. Defaults to top 25. \code{genes}}

\item{genes}{List of genes among which interactions should be tested. If not provided, test will be performed between top 25 genes.}

\item{pvalue}{Default c(0.05, 0.01) p-value threshold. You can provide two values for upper and lower threshold.}

\item{returnAll}{If TRUE returns test statistics for all pair of tested genes. Default FALSE, returns for only genes below pvalue threshold.}

\item{findPathways}{Uses all mutually exclusive set of genes to further identify altered pathways. Default TRUE}

\item{kMax}{Default 3. maximum gene set size if findPathways is TRUE. This is time consuming for > 3.}

\item{fontSize}{cex for gene names. Default 0.8}

\item{verbose}{Default TRUE}
}
\value{
list of data.tables
}
\description{
Performs Pair-wise Fisher's Exact test to detect mutually exclusive or co-occuring events. Also identifies gene sets mutated significantly.
}
\details{
This function and plotting is inspired from genetic interaction analysis performed in the published study combining gene expression and mutation data in MDS. See reference for details.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
somaticInteractions(maf = laml, top = 5)
}
\references{
Gerstung M, Pellagatti A, Malcovati L, et al. Combining gene mutation with gene expression data improves outcome prediction in myelodysplastic syndromes. Nature Communications. 2015;6:5901. doi:10.1038/ncomms6901.
}
