% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signatureCorrelation.R
\name{signatureEnrichment}
\alias{signatureEnrichment}
\title{Performs sample stratification based on signature contribution and enrichment analysis.}
\usage{
signatureEnrichment(maf, sig_res, minMut = 5, useCNV = FALSE, fn = NULL)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object used for signature analysis.}

\item{sig_res}{Signature results from \code{\link{extractSignatures}}}

\item{minMut}{Consider only genes with minimum this number of samples mutated. Default 5.}

\item{useCNV}{whether to include copy number events. Only applicable when MAF is read along with copy number data. Default TRUE if available.}

\item{fn}{basename for output file. Default NULL.}
}
\value{
result list containing p-values
}
\description{
Performs k-means clustering to assign signature to samples and performs enrichment analysis.
}
\seealso{
\code{\link{plotEnrichmentResults}}
}
