% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readGistic.R
\name{readGistic}
\alias{readGistic}
\title{Read and summarize gistic output.}
\usage{
readGistic(gisticAllLesionsFile = NULL, gisticAmpGenesFile = NULL,
  gisticDelGenesFile = NULL, gisticScoresFile = NULL, cnLevel = "all",
  isTCGA = FALSE)
}
\arguments{
\item{gisticAllLesionsFile}{All Lesions file generated by gistic. e.g; all_lesions.conf_XX.txt, where XX is the confidence level. Required. Default NULL.}

\item{gisticAmpGenesFile}{Amplification Genes file generated by gistic. e.g; amp_genes.conf_XX.txt, where XX is the confidence level. Default NULL.}

\item{gisticDelGenesFile}{Deletion Genes file generated by gistic. e.g; del_genes.conf_XX.txt, where XX is the confidence level. Default NULL.}

\item{gisticScoresFile}{scores.gistic file generated by gistic.}

\item{cnLevel}{level of CN changes to use. Can be 'all', 'deep' or 'shallow'. Default uses all i.e, genes with both 'shallow' or 'deep' CN changes}

\item{isTCGA}{Is the data from TCGA. Default FALSE.}
}
\value{
A list of summarized data.
}
\description{
A little function to summarize gistic output files. Summarized output is returned as a list of tables.
}
\details{
Requires output files generated from GISTIC. Gistic documentation can be found here ftp://ftp.broadinstitute.org/pub/GISTIC2.0/GISTICDocumentation_standalone.htm
}
\examples{
all.lesions <- system.file("extdata", "all_lesions.conf_99.txt", package = "maftools")
amp.genes <- system.file("extdata", "amp_genes.conf_99.txt", package = "maftools")
del.genes <- system.file("extdata", "del_genes.conf_99.txt", package = "maftools")
scores.gistic <- system.file("extdata", "scores.gistic", package = "maftools")
laml.gistic = readGistic(gisticAllLesionsFile = all.lesions, gisticAmpGenesFile = amp.genes, gisticDelGenesFile = del.genes, gisticScoresFile = scores.gistic, isTCGA = TRUE)
}
