% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rainfallPlot.R
\name{rainfallPlot}
\alias{rainfallPlot}
\title{Rainfall plot to display hyper mutated genomic regions.}
\usage{
rainfallPlot(maf, tsb = NULL, detectChangePoints = FALSE,
  ref.build = "hg19", color = NULL, savePlot = FALSE, width = 6,
  height = 3, fontSize = 12, pointSize = 1)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}. Required.}

\item{tsb}{specify sample names (Tumor_Sample_Barcodes) for which plotting has to be done. If NULL, draws plot for most mutated sample.}

\item{detectChangePoints}{If TRUE, detectes genomic change points where potential kataegis are formed. Results are written to an output tab delimted file.}

\item{ref.build}{Reference build for chromosome sizes. Can be hg18, hg19 or hg38. Default hg19.}

\item{color}{named vector of colors for each coversion class.}

\item{savePlot}{If TRUE plot is saved to output pdf. Default FALSE.}

\item{width}{width of plot to be saved.}

\item{height}{height of plot to be saved.}

\item{fontSize}{Default 12.}

\item{pointSize}{Default 2.}
}
\value{
returns ggplot object of the plot which can be further modified. Results are written to an output file with suffix changePoints.tsv
}
\description{
Plots inter variant distance as a function of genomic locus.
}
\details{
If `detectChangePoints`` is set to TRUE, this method will use Change-Point detection method to identify genomic loci where average inter-mutation distance changes from the backgorund.
Segments detected with less than 6 mutations are filtered out.
}
