% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSignatures.R
\name{plotSignatures}
\alias{plotSignatures}
\title{Plots decomposed mutational signatures}
\usage{
plotSignatures(nmfRes = NULL, contributions = FALSE, color = NULL,
  patient_order = NULL, font_size = 1.2, show_title = TRUE,
  axis_lwd = 2, title_size = 0.9, show_barcodes = FALSE, yaxisLim = 0.3,
  ...)
}
\arguments{
\item{nmfRes}{results from \code{\link{extractSignatures}}}

\item{contributions}{If TRUE plots contribution of signatures in each sample.}

\item{color}{colors for each Ti/Tv conversion class. Default NULL}

\item{patient_order}{User defined ordering of samples. Default NULL.}

\item{font_size}{font size. Default 1.2}

\item{show_title}{Default TRUE}

\item{axis_lwd}{axis width. Default 2.}

\item{title_size}{size of title. Default 1.3}

\item{show_barcodes}{Default FALSE}

\item{yaxisLim}{Default 0.3. If NA autoscales.}

\item{...}{further plot options passed to \code{\link{barplot}}}
}
\value{
ggplot object if contributions is TRUE
}
\description{
Takes results from \code{\link{extractSignatures}} and plots decomposed mutational signatures as a barplot.
}
\seealso{
\code{\link{trinucleotideMatrix}} \code{\link{plotSignatures}}
}
