% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotClusters.R
\name{plotClusters}
\alias{plotClusters}
\title{Plot density plots from clutering results.}
\usage{
plotClusters(clusters, tsb = NULL, genes = NULL, showCNvars = FALSE,
  savePlot = FALSE, width = 6, height = 5, colors = NULL)
}
\arguments{
\item{clusters}{clustering results from \code{\link{inferHeterogeneity}}}

\item{tsb}{sample to plot from clustering results. Default plots all samples from results.}

\item{genes}{genes to highlight on the plot. Can be a vector of gene names, \code{CN_altered} to label copy number altered varinats.
or \code{all} to label all genes. Default NULL.}

\item{showCNvars}{show copy numbered altered variants on the plot. Default FALSE.}

\item{savePlot}{If TRUE saves plot to output pdf}

\item{width}{plot width. Default 6.}

\item{height}{plot height. Default 5.}

\item{colors}{manual colors for clusters. Default NULL.}
}
\value{
returns nothing.
}
\description{
Plots results from inferHeterogeneity.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
seg = system.file('extdata', 'TCGA.AB.3009.hg19.seg.txt', package = 'maftools')
TCGA.AB.3009.clust <- inferHeterogeneity(maf = laml, tsb = 'TCGA-AB-3009',
segFile = seg, vafCol = 'i_TumorVAF_WU')
plotClusters(TCGA.AB.3009.clust, genes = c('NF1', 'SUZ12'), showCNvars = TRUE)
}
\seealso{
\code{\link{inferHeterogeneity}}
}
