% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domainSummary.R
\name{pfamDomains}
\alias{pfamDomains}
\title{pfam domain annotation and summarization.}
\usage{
pfamDomains(maf = NULL, AACol = NULL, summarizeBy = "AAPos", top = 5,
  domainsToLabel = NULL, baseName = NULL, varClass = "nonSyn",
  width = 5, height = 5, labelSize = 3)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{AACol}{manually specify column name for amino acid changes. Default looks for field 'AAChange'}

\item{summarizeBy}{Summarize domains by amino acid position or conversions. Can be "AAPos" or "AAChange"}

\item{top}{How many top mutated domains to label in the scatter plot. Defaults to 5.}

\item{domainsToLabel}{Default NULL. Exclusive with top argument.}

\item{baseName}{If given writes the results to output file. Default NULL.}

\item{varClass}{which variants to consider for summarization. Can be nonSyn, Syn or all. Default nonSyn.}

\item{width}{width of the file to be saved.}

\item{height}{height of the file to be saved.}

\item{labelSize}{font size for labels. Default 3.}
}
\value{
returns a list two tables summarized by amino acid positions and domains respectively. Also plots top 5 most mutated domains as scatter plot.
}
\description{
Summarizes amino acid positions and annotates them with pfam domain information.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
pfamDomains(maf = laml, AACol = 'Protein_Change')
}
