% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pancanAnalysis.R
\name{pancanComparison}
\alias{pancanComparison}
\title{Perform PacCancer analysis}
\usage{
pancanComparison(mutsigResults, qval = 0.1, cohortName = "input",
  inputSampleSize = NULL, label = 1, genesToLabel = NULL,
  normSampleSize = FALSE, file = NULL, width = 6, height = 6,
  pointSize = 3, labelSize = 3)
}
\arguments{
\item{mutsigResults}{MutSig results (usually sig_genes.txt). Can be gz compressed.}

\item{qval}{qvalue threshold to define SMG. Default 0.1}

\item{cohortName}{Input cohort name.}

\item{inputSampleSize}{Sample size from MAF file used to generate mutSig results. Optional.}

\item{label}{Default 1. Can be 1, 2 or 3.}

\item{genesToLabel}{Default NULL. Exclusive with label argument.}

\item{normSampleSize}{normalizes gene sizes to draw bubble plot. Requires inputSampleSize. i.e, bubble sizes proportional to fraction of samples in which the gene is mutated.}

\item{file}{basename for output file (both raw data and plot are saved)}

\item{width}{width of the file to be saved.}

\item{height}{height of the file to be saved.}

\item{pointSize}{size for scatter plot. Default 1.}

\item{labelSize}{label text size. Default 3}
}
\value{
ggplot object
}
\description{
Takes MutSig results and compares them against PanCancer results.
}
\details{
This function takes MutSig results and compares them against panCancer cohort (~5000 tumor samples from 21 cancer types). This analysis can reveal
novel genes exclusively mutated in input cohort.
}
\examples{
laml.mutsig <- system.file("extdata", "LAML_sig_genes.txt.gz", package = "maftools")
pancanComparison(mutsigResults = laml.mutsig, qval = 0.1, cohortName = 'LAML', inputSampleSize = 200, label = 1, normSampleSize = TRUE)
}
\references{
Lawrence MS, Stojanov P, Mermel CH, et al. Discovery and saturation analysis of cancer genes across 21 tumor types. Nature. 2014;505(7484):495-501. doi:10.1038/nature12912.
}
