% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oncotate.R
\name{oncotate}
\alias{oncotate}
\title{Annotates given variants using oncotator api.}
\usage{
oncotate(maflite, header = FALSE, basename = NULL)
}
\arguments{
\item{maflite}{input tsv file or a data.frame with chr, start, end, ref_allele, alt_allele columns. (rest of the columns, if present will be attached to the output maf)}

\item{header}{logical. Whether input has a header line. Default is FALSE. Only applicable when the input is a tsv file.}

\item{basename}{NULL. if basename is given, annotations will be written to <basename>.maf file.}
}
\value{
returns a data.table in maf format.
}
\description{
Takes input variants and annotates them using Broad's oncotator api (http://www.broadinstitute.org/oncotator/). Output is a dataframe of annotated variants in maf format.

Input should be tsv file or a data.frame with first five columns in the order chr, start, end, ref_allele, alt_allele (and so on, but only first five will used, rest will be attached to resulting maf file). Note: Time consuming if input is huge.
Try to include necessary columns such as Tumor_Sample_Barcode along with above 5 fields. Only supports hg19/GRCh37 build.
}
\examples{
sample.var = data.frame(chromsome = c('chr4', 'chr15'), Start = c(55589774, 41961117),
end = c(55589774, 41961117), ref = c('A', 'TGGCTAA'), alt = c('G', '-'),
Tumor_Sample_Barcode = c('fake_1', 'fake2'))
write.table(sample.var, 'sampleVars.txt', sep='\\t',quote = FALSE, row.names = FALSE)
##var.maf <- oncotate(maflite = 'sampleVars.txt', header = TRUE)
}
