% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oncostrip.R
\name{oncostrip}
\alias{oncostrip}
\title{draw an oncostrip similar to cBioportal oncoprinter output.}
\usage{
oncostrip(maf, genes = NULL, top = 5, colors = NULL, sort = TRUE,
  clinicalFeatures = NULL, annotationDat = NULL, sortByAnnotation = FALSE,
  annotationOrder = NULL, removeNonMutated = TRUE,
  showTumorSampleBarcodes = FALSE, annotationColor = NULL, fontSize = 10,
  titleFontSize = 15, legendFontSize = 12)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{read.maf}}

\item{genes}{draw oncoprint for these genes. default NULL. Plots top 5 genes.}

\item{top}{how many top genes to be drawn. defaults to 5.}

\item{colors}{named vector of colors for each Variant_Classification.}

\item{sort}{logical sort oncomatrix for enhanced visualization. Defaults to TRUE.}

\item{clinicalFeatures}{columns names from `clinical.data` slot of \code{MAF} to be drawn in the plot. Dafault NULL.}

\item{annotationDat}{If MAF file was read without annotations, provide a custom \code{data.frame} with a column containing Tumor_Sample_Barcodes along with rest of columns with annotations.
You can specify which columns to be drawn using `clinicalFeatures` argument.}

\item{sortByAnnotation}{logical sort oncomatrix (samples) by provided `clinicalFeatures` Defaults to FALSE. column-sort.}

\item{annotationOrder}{Manually specify order for annotations. Works only for first `clinicalFeatures`. Default NULL.}

\item{removeNonMutated}{Logical. If \code{TRUE} removes samples with no mutations in the oncoplot for better visualization. Default TRUE.}

\item{showTumorSampleBarcodes}{logical to include sample names.}

\item{annotationColor}{list of colors to use for `clinicalFeatures`. Must be a named list. Default NULL.}

\item{fontSize}{font size for gene names. Default 10.}

\item{titleFontSize}{font size for title. Default 15}

\item{legendFontSize}{font size for legend. Default 12}
}
\value{
None.
}
\description{
draw an oncostrip similar to cBioportal oncoprinter output.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
dev.new()
oncostrip(maf = laml, genes = c('NPM1', 'RUNX1'))

}
\seealso{
\code{\link{oncoplot}}
}
