% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oncoplot.R
\name{oncoplot}
\alias{oncoplot}
\title{draw an oncoplot}
\usage{
oncoplot(maf, top = 20, genes = NULL, mutsig = NULL, mutsigQval = 0.1,
  drawRowBar = TRUE, drawColBar = TRUE, clinicalFeatures = NULL,
  annotationDat = NULL, annotationColor = NULL, genesToIgnore = NULL,
  showTumorSampleBarcodes = FALSE, removeNonMutated = TRUE, colors = NULL,
  sortByMutation = FALSE, sortByAnnotation = FALSE,
  annotationOrder = NULL, keepGeneOrder = FALSE, GeneOrderSort = TRUE,
  sampleOrder = NULL, writeMatrix = FALSE, fontSize = 10,
  SampleNamefontSize = 10, titleFontSize = 15, legendFontSize = 12,
  annotationFontSize = 12, annotationTitleFontSize = 12)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{top}{how many top genes to be drawn. defaults to 20.}

\item{genes}{Just draw oncoplot for these genes. Default NULL.}

\item{mutsig}{Mutsig resuts if availbale. Usually file named sig_genes.txt If provided plots significant genes and correpsonding Q-values as side row-bar. Default NULL.}

\item{mutsigQval}{Q-value to choose significant genes from mutsig results. Default 0.1}

\item{drawRowBar}{logical plots barplot for each gene. Default \code{TRUE}.}

\item{drawColBar}{logical plots barplot for each sample. Default \code{TRUE}.}

\item{clinicalFeatures}{columns names from `clinical.data` slot of \code{MAF} to be drawn in the plot. Dafault NULL.}

\item{annotationDat}{If MAF file was read without clinical data, provide a custom \code{data.frame} with a column containing Tumor_Sample_Barcodes along with rest of columns with annotations.
You can specify which columns to be drawn using `clinicalFeatures` argument.}

\item{annotationColor}{list of colors to use for `clinicalFeatures`. Must be a named list. Default NULL.}

\item{genesToIgnore}{do not show these genes in Oncoplot. Default NULL.}

\item{showTumorSampleBarcodes}{logical to include sample names.}

\item{removeNonMutated}{Logical. If \code{TRUE} removes samples with no mutations in the oncoplot for better visualization. Default \code{TRUE}.}

\item{colors}{named vector of colors for each Variant_Classification.}

\item{sortByMutation}{Force sort matrix according mutations. Helpful in case of MAF was read along with copy number data. Default FALSE.}

\item{sortByAnnotation}{logical sort oncomatrix (samples) by provided `clinicalFeatures`. Sorts based on first `clinicalFeatures`.  Defaults to FALSE. column-sort}

\item{annotationOrder}{Manually specify order for annotations. Works only for first `clinicalFeatures`. Default NULL.}

\item{keepGeneOrder}{logical whether to keep order of given genes. Default FALSE, order according to mutation frequency}

\item{GeneOrderSort}{logical this is applicable when `keepGeneOrder` is TRUE. Default TRUE}

\item{sampleOrder}{Manually speify sample names for oncolplot ordering. Default NULL.}

\item{writeMatrix}{writes character coded matrix used to generate the plot to an output file. This can be used as an input
for ComplexHeatmap \link[ComplexHeatmap]{oncoPrint} function if you wish to customize the plot.}

\item{fontSize}{font size for gene names. Default 10.}

\item{SampleNamefontSize}{font size for sample names. Default 10}

\item{titleFontSize}{font size for title. Default 15}

\item{legendFontSize}{font size for legend. Default 12}

\item{annotationFontSize}{font size for annotations. Default 12}

\item{annotationTitleFontSize}{font size for annotation title. Default 12}
}
\value{
None.
}
\description{
takes output generated by read.maf and draws an oncoplot
}
\details{
Takes maf file as input and plots it as a matrix. Any desired clincal features can be added at the bottom of the oncoplot by providing \code{clinicalFeatures}.
Oncoplot can be sorted either by mutations or by clinicalFeatures using arguments \code{sortByMutation} and \code{sortByAnnotation} respectively.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
oncoplot(maf = laml, top = 3)
}
\seealso{
\code{\link{oncostrip}}
}
