% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countMatrix.R
\name{mutCountMatrix}
\alias{mutCountMatrix}
\title{Generates count matrix of mutations.}
\usage{
mutCountMatrix(maf, includeSyn = FALSE, countOnly = NULL,
  removeNonMutated = TRUE)
}
\arguments{
\item{maf}{an MAF object generated by \code{\link{read.maf}}}

\item{includeSyn}{whether to include sysnonymous variants in ouput matrix. Default FALSE}

\item{countOnly}{Default NULL - counts all variants. You can specify type of 'Variant_Classification' to count. For e.g, countOnly = 'Splice_Site' will generates matrix for only Splice_Site variants.}

\item{removeNonMutated}{Logical Default \code{TRUE}, removes samples with no mutations from the matrix.}
}
\value{
Integer Matrix
}
\description{
Generates a count matrix of mutations. i.e, number of mutations per gene per sample.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
##Generate matrix
mutCountMatrix(maf = laml)
##Generate count matrix of Splice_Site mutations
mutCountMatrix(maf = laml, countOnly = 'Splice_Site')
}
\seealso{
\code{\link{getFields}} \code{\link{getGeneSummary}} \code{\link{getSampleSummary}}
}
