% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mafCompare.R
\name{mafCompare}
\alias{mafCompare}
\title{compare two cohorts (MAF).}
\usage{
mafCompare(m1, m2, m1Name = NULL, m2Name = NULL, minMut = 5,
  useCNV = TRUE)
}
\arguments{
\item{m1}{first \code{\link{MAF}} object}

\item{m2}{second \code{\link{MAF}} object}

\item{m1Name}{optional name for first cohort}

\item{m2Name}{optional name for second cohort}

\item{minMut}{Consider only genes with minimum this number of samples mutated in atleast one of the cohort for analysis. Helful to ignore single mutated genes. Default 5.}

\item{useCNV}{whether to include copy number events to compare MAFs. Only applicable when MAF is read along with copy number data. Default TRUE if available.}
}
\value{
result list
}
\description{
compare two cohorts (MAF).
}
\details{
Performs fisher test on 2x2 contigency table generated from two cohorts to find differentially mutated genes.
}
\examples{
primary.apl <- system.file("extdata", "APL_primary.maf.gz", package = "maftools")
relapse.apl <- system.file("extdata", "APL_relapse.maf.gz", package = "maftools")
primary.apl <- read.maf(maf = primary.apl)
relapse.apl <- read.maf(maf = relapse.apl)
pt.vs.rt <- mafCompare(m1 = primary.apl, m2 = relapse.apl, m1Name = 'Primary',
m2Name = 'Relapse', minMut = 5)
}
\seealso{
\code{\link{forestPlot}}

\code{\link{lollipopPlot2}}
}
