% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lollipopPlot2.R
\name{lollipopPlot2}
\alias{lollipopPlot2}
\title{Compare two lollipop plots}
\usage{
lollipopPlot2(m1, m2, gene = NULL, AACol1 = NULL, AACol2 = NULL,
  m1_name = NULL, m2_name = NULL, m1_label = NULL, m2_label = NULL,
  refSeqID = NULL, proteinID = NULL, labPosAngle = 0, labPosSize = 0.9,
  colors = NULL, axisTextSize = c(1, 1), pointSize = 1.2,
  domainLabelSize = 1, legendTxtSize = 1)
}
\arguments{
\item{m1}{first \code{\link{MAF}} object}

\item{m2}{second \code{\link{MAF}} object}

\item{gene}{HGNC symbol for which protein structure to be drawn.}

\item{AACol1}{manually specify column name for amino acid changes in m1. Default looks for fields 'HGVSp_Short', 'AAChange' or 'Protein_Change'.}

\item{AACol2}{manually specify column name for amino acid changes in m2. Default looks for fields 'HGVSp_Short', 'AAChange' or 'Protein_Change'.}

\item{m1_name}{name for \code{m1} cohort. optional.}

\item{m2_name}{name for \code{m2} cohort. optional.}

\item{m1_label}{Amino acid positions to label for \code{m1} cohort. If 'all', labels all variants.}

\item{m2_label}{Amino acid positions to label for \code{m2} cohort. If 'all', labels all variants.}

\item{refSeqID}{RefSeq transcript identifier for \code{gene} if known.}

\item{proteinID}{RefSeq protein identifier for \code{gene} if known.}

\item{labPosAngle}{angle for labels. Defaults to horizonal 0 degree labels. Set to 90 for vertical; 45 for diagonal labels.}

\item{labPosSize}{Text size for labels. Default 3}

\item{colors}{named vector of colors for each Variant_Classification. Default NULL.}

\item{axisTextSize}{text size for axis labels. Default 1.}

\item{pointSize}{size of lollipop heads. Default 1.2}

\item{domainLabelSize}{text size for domain labels. Default 1.}

\item{legendTxtSize}{Default 1.}
}
\description{
Compare two lollipop plots
}
\details{
Draws lollipop plot for a gene from two cohorts
}
\examples{
primary.apl <- system.file("extdata", "APL_primary.maf.gz", package = "maftools")
relapse.apl <- system.file("extdata", "APL_relapse.maf.gz", package = "maftools")
primary.apl <- read.maf(maf = primary.apl)
relapse.apl <- read.maf(maf = relapse.apl)
lollipopPlot2(m1 = primary.apl, m2 = relapse.apl, gene = "FLT3",AACol1 = "amino_acid_change", AACol2 = "amino_acid_change", m1_name = "Primary", m2_name = "Relapse")
}
\seealso{
\code{\link{lollipopPlot}}

\code{\link{mafCompare}}
}
