% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lollipopPlot.R
\name{lollipopPlot}
\alias{lollipopPlot}
\title{Draws lollipop plot of amino acid changes on to Protein structure.}
\usage{
lollipopPlot(maf, gene = NULL, AACol = NULL, labelPos = NULL,
  labPosSize = 3, showMutationRate = TRUE, fn = NULL,
  showDomainLabel = TRUE, cBioPortal = FALSE, refSeqID = NULL,
  proteinID = NULL, repel = FALSE, collapsePosLabel = TRUE,
  legendTxtSize = 10, labPosAngle = 0, domainLabelSize = 2.5,
  axisTextSize = c(9, 12), printCount = FALSE, colors = NULL,
  domainColors = NULL, labelOnlyUniqueDoamins = TRUE, defaultYaxis = TRUE,
  titleSize = c(12, 10), pointSize = 1.5)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{gene}{HGNC symbol for which protein structure to be drawn.}

\item{AACol}{manually specify column name for amino acid changes. Default looks for fields 'HGVSp_Short', 'AAChange' or 'Protein_Change'. Changes can be of any format i.e, can be a numeric value or HGVSp annotations (e.g; p.P459L, p.L2195Pfs*30 or p.Leu2195ProfsTer30)}

\item{labelPos}{Amino acid positions to label. If 'all', labels all variants.}

\item{labPosSize}{Text size for labels. Default 3}

\item{showMutationRate}{Default TRUE}

\item{fn}{basename for plot file to be saved. If provided a pdf will be generated. Default NULL.}

\item{showDomainLabel}{Label domains within the plot. Default TRUE. If FALSE they will be annotated in legend.}

\item{cBioPortal}{Adds annotations similar to cBioPortals MutationMapper and collapse Variants into Truncating and rest.}

\item{refSeqID}{RefSeq transcript identifier for \code{gene} if known.}

\item{proteinID}{RefSeq protein identifier for \code{gene} if known.}

\item{repel}{If points are too close to each other, use this option to repel them. Default FALSE. Warning: naive method, might make plot ugly in case of too many variants!}

\item{collapsePosLabel}{Collapses overlapping labels at same position. Default TRUE}

\item{legendTxtSize}{Text size for legend. Default 10}

\item{labPosAngle}{angle for labels. Defaults to horizonal 0 degree labels. Set to 90 for vertical; 45 for diagonal labels.}

\item{domainLabelSize}{text size for domain labels. Default 2.}

\item{axisTextSize}{text size x and y tick labels. Default c(9,12).}

\item{printCount}{If TRUE, prints number of summarized variants for the given protein.}

\item{colors}{named vector of colors for each Variant_Classification. Default NULL.}

\item{domainColors}{Manual colors for protein domains}

\item{labelOnlyUniqueDoamins}{Default TRUE only labels unique doamins.}

\item{defaultYaxis}{If FALSE, just labels min and maximum y values on y axis.}

\item{titleSize}{font size for title and subtitle. Default c(12, 10)}

\item{pointSize}{size of lollipop heads. Default 1.5}
}
\value{
ggplot object of the plot, which can be futher modified.
}
\description{
Draws lollipop plot of amino acid changes.
}
\details{
This function by default looks for fields 'HGVSp_Short', 'AAChange' or 'Protein_Change' in maf file. One can also manually specify field name containing amino acid changes.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
lollipopPlot(maf = laml, gene = 'KIT', AACol = 'Protein_Change')

}
