% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icgc_to_maf.R
\name{icgcSimpleMutationToMAF}
\alias{icgcSimpleMutationToMAF}
\title{Converts ICGC Simple Somatic Mutation format file to MAF}
\usage{
icgcSimpleMutationToMAF(icgc, basename = NA, MAFobj = FALSE,
  clinicalData = NULL, removeDuplicatedVariants = TRUE,
  addHugoSymbol = FALSE)
}
\arguments{
\item{icgc}{Input data in ICGC Simple Somatic Mutation format. Can be gz compressed.}

\item{basename}{If given writes to output file with basename.}

\item{MAFobj}{If TRUE returns results as an \code{\link{MAF}} object.}

\item{clinicalData}{Clinical data associated with each sample/Tumor_Sample_Barcode in MAF. Could be a text file or a data.frame. Default NULL.}

\item{removeDuplicatedVariants}{removes repeated variants in a particuar sample, mapped to multiple transcripts of same Gene. See Description. Default TRUE.}

\item{addHugoSymbol}{If TRUE replaces ensemble gene IDs with Hugo_Symbols. Default FALSE.}
}
\value{
tab delimited MAF file.
}
\description{
Converts ICGC Simple Somatic Mutation format file to Mutation Annotation Format. Basic fields are converted as per MAF specififcations, rest of the fields are retained as in the input file.
Ensemble gene IDs are converted to HGNC Symbols. Note that by default Simple Somatic Mutation format contains all affected transcripts of a variant resuting in
multiple entries of the same variant in same sample. It is hard to choose a single affected transcript based on annotations alone and by default this program removes repeated variants as duplicated entries.
If you wish to keep all of them, set removeDuplicatedVariants to FALSE.
}
\details{
ICGC Simple Somatic Mutattion format specififcation can be found here: http://docs.icgc.org/submission/guide/icgc-simple-somatic-mutation-format/
}
\examples{
esca.icgc <- system.file("extdata", "simple_somatic_mutation.open.ESCA-CN.sample.tsv.gz", package = "maftools")
esca.maf <- icgcSimpleMutationToMAF(icgc = esca.icgc)
}
