% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisticOncoPlot.R
\name{gisticOncoPlot}
\alias{gisticOncoPlot}
\title{Plot gistic results.}
\usage{
gisticOncoPlot(gistic, top = NULL, showTumorSampleBarcodes = FALSE,
  clinicalData = NULL, clinicalFeatures = NULL, sortByAnnotation = FALSE,
  annotationColor = NULL, bandsToIgnore = NULL, removeNonAltered = FALSE,
  colors = NULL, fontSize = 10)
}
\arguments{
\item{gistic}{an \code{\link{GISTIC}} object generated by \code{\link{readGistic}}}

\item{top}{how many top cytobands to be drawn. defaults to all.}

\item{showTumorSampleBarcodes}{logical to include sample names.}

\item{clinicalData}{data.frame with columns containing Tumor_Sample_Barcodes and rest of columns with annotations.}

\item{clinicalFeatures}{columns names from `clinicalData` to be drawn in the plot. Dafault NULL.}

\item{sortByAnnotation}{logical sort oncomatrix (samples) by provided `clinicalFeatures`. Defaults to FALSE. column-sort}

\item{annotationColor}{list of colors to use for clinicalFeatures. Default NULL.}

\item{bandsToIgnore}{do not show these bands in the plot Default NULL.}

\item{removeNonAltered}{Logical. If \code{TRUE} removes samples with no mutations in the oncoplot for better visualization. Default \code{FALSE}.}

\item{colors}{named vector of colors Amp and Del events.}

\item{fontSize}{font size for cytoband names. Default 10.}
}
\value{
None.
}
\description{
takes output generated by readGistic and draws a plot similar to oncoplot.
}
\details{
Takes gistic file as input and plots it as a matrix. Any desired annotations can be added at the bottom of the oncoplot by providing \code{annotation}
}
\examples{
all.lesions <- system.file("extdata", "all_lesions.conf_99.txt", package = "maftools")
amp.genes <- system.file("extdata", "amp_genes.conf_99.txt", package = "maftools")
del.genes <- system.file("extdata", "del_genes.conf_99.txt", package = "maftools")
scores.gistic <- system.file("extdata", "scores.gistic", package = "maftools")
laml.gistic = readGistic(gisticAllLesionsFile = all.lesions, gisticAmpGenesFile = amp.genes, gisticDelGenesFile = del.genes, gisticScoresFile = scores.gistic)
gisticOncoPlot(laml.gistic)
}
\seealso{
\code{\link{oncostrip}}
}
