% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisticBubblePlot.R
\name{gisticBubblePlot}
\alias{gisticBubblePlot}
\title{Plot gistic results as a bubble plot}
\usage{
gisticBubblePlot(gistic = NULL, color = NULL, markBands = NULL,
  fdrCutOff = 0.1, txtSize = 3, file = NULL, width = 6, height = 5)
}
\arguments{
\item{gistic}{an object of class \code{GISTIC} generated by \code{readGistic}}

\item{color}{colors for Amp and Del events.}

\item{markBands}{any cytobands to label.}

\item{fdrCutOff}{fdr cutoff to use. Default 0.1}

\item{txtSize}{label size for bubbles.}

\item{file}{if given saves plot as a pdf.}

\item{width}{width of the file to be saved.}

\item{height}{height of the file to be saved.}
}
\value{
invisible ggplot2 object
}
\description{
Plots significantly altered cytobands as a function of number samples in which it is altered and number genes it contains. Size of each bubble is according to -log10 transformed q values.
}
\examples{
all.lesions <- system.file("extdata", "all_lesions.conf_99.txt", package = "maftools")
amp.genes <- system.file("extdata", "amp_genes.conf_99.txt", package = "maftools")
del.genes <- system.file("extdata", "del_genes.conf_99.txt", package = "maftools")
scores.gistic <- system.file("extdata", "scores.gistic", package = "maftools")
laml.gistic = readGistic(gisticAllLesionsFile = all.lesions, gisticAmpGenesFile = amp.genes, gisticDelGenesFile = del.genes, gisticScoresFile = scores.gistic)
gisticBubblePlot(gistic = laml.gistic)
}
