% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genesToBarcodes.R
\name{genesToBarcodes}
\alias{genesToBarcodes}
\title{Extracts Tumor Sample Barcodes where the given genes are mutated.}
\usage{
genesToBarcodes(maf, genes = NULL, justNames = FALSE)
}
\arguments{
\item{maf}{an \code{\link{MAF}} object generated by \code{\link{read.maf}}}

\item{genes}{Hogo_Symbol for which sample names to be extracted.}

\item{justNames}{if TRUE, just returns samples names instead of summarized tables.}
}
\value{
list of \code{data.table}s with samples in which given genes are mutated.
}
\description{
Extracts Tumor Sample Barcodes where the given genes are mutated.
}
\examples{
laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.maf)
genesToBarcodes(maf = laml, genes = 'DNMT3A')
}
