% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneCloud.R
\name{geneCloud}
\alias{geneCloud}
\title{Plots wordcloud.}
\usage{
geneCloud(input, minMut = 3, col = NULL, top = NULL,
  genesToIgnore = NULL, ...)
}
\arguments{
\item{input}{an \code{\link{MAF}} or \code{\link{GISTIC}} object generated by \code{\link{read.maf}} or \code{\link{readGistic}}}

\item{minMut}{Minimum number of samples in which a gene is required to be mutated.}

\item{col}{vector of colors to choose from.}

\item{top}{Just plot these top n number of mutated genes.}

\item{genesToIgnore}{Ignore these genes.}

\item{...}{Other options passed to \code{\link{wordcloud}}}
}
\value{
nothing.
}
\description{
Plots word cloud of mutated genes or altered cytobands with size proportional to the event frequency.
}
\examples{
laml.input <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
laml <- read.maf(maf = laml.input, useAll = FALSE)
geneCloud(input = laml, minMut = 5)
}
