% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractSignatures.R
\name{extractSignatures}
\alias{extractSignatures}
\title{Extract mutational signatures from trinucleotide context.}
\usage{
extractSignatures(mat, n = NULL, nTry = 6, plotBestFitRes = FALSE,
  parallel = NULL)
}
\arguments{
\item{mat}{Input matrix of diemnsion nx96 generated by \code{\link{trinucleotideMatrix}}}

\item{n}{decompose matrix into n signatures. Default NULL. Tries to predict best value for \code{n} by running NMF on a range of values and chooses based on cophenetic correlation coefficient.}

\item{nTry}{tries upto this number of signatures before choosing best \code{n}. Default 6.}

\item{plotBestFitRes}{plots consensus heatmap for range of values tried. Default FALSE}

\item{parallel}{calls to .opt argument of \code{\link{nmf}}. e.g, 'P4' for using 4 cores. See note on \code{\link{nmf}} for MAC users.}
}
\value{
a list with decomposed scaled signatures, signature contributions in each sample and a cosine similarity table against validated signatures.
}
\description{
Decompose a matrix of 96 substitution classes into \code{n} signatures.
}
\details{
This function decomposes a non-negative matrix into n signatures.
Extracted signatures are compared against 30 experimentally validated signatures by calculating cosine similarity. See http://cancer.sanger.ac.uk/cosmic/signatures for details.
}
\examples{
\dontrun{
laml.tnm <- trinucleotideMatrix(maf = laml, ref_genome = 'hg19.fa', prefix = 'chr',
add = TRUE, useSyn = TRUE)
laml.sign <- extractSignatures(mat = laml.tnm, plotBestFitRes = FALSE)
}
}
\seealso{
\code{\link{trinucleotideMatrix}} \code{\link{plotSignatures}}
}
