% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coOncoplot.R
\name{coOncoplot}
\alias{coOncoplot}
\title{Draw two oncoplots side by side for cohort comparision.}
\usage{
coOncoplot(m1, m2, genes = NULL, m1Name = NULL, m2Name = NULL,
  clinicalFeatures1 = NULL, clinicalFeatures2 = NULL,
  annotationColor1 = NULL, annotationColor2 = NULL, colors = NULL,
  removeNonMutated = TRUE, geneNamefont = 10, showSampleNames = FALSE,
  SampleNamefont = 10, legendFontSize = 10, titleFontSize = 12,
  keepGeneOrder = FALSE, includeSyn = FALSE)
}
\arguments{
\item{m1}{first \code{\link{MAF}} object}

\item{m2}{second \code{\link{MAF}} object}

\item{genes}{draw these genes. Default plots top 5 mutated genes from two cohorts.}

\item{m1Name}{optional name for first cohort}

\item{m2Name}{optional name for second cohort}

\item{clinicalFeatures1}{columns names from `clinical.data` slot of m1 \code{MAF} to be drawn in the plot. Dafault NULL.}

\item{clinicalFeatures2}{columns names from `clinical.data` slot of m2 \code{MAF} to be drawn in the plot. Dafault NULL.}

\item{annotationColor1}{list of colors to use for `clinicalFeatures1` Default NULL.}

\item{annotationColor2}{list of colors to use for `clinicalFeatures2` Default NULL.}

\item{colors}{named vector of colors for each Variant_Classification.}

\item{removeNonMutated}{Logical. If \code{TRUE} removes samples with no mutations in the oncoplot for better visualization. Default \code{TRUE}.}

\item{geneNamefont}{font size for gene names. Default 10}

\item{showSampleNames}{whether to show sample names. Defult FALSE.}

\item{SampleNamefont}{font size for sample names. Default 10}

\item{legendFontSize}{font size for legend. Default 10}

\item{titleFontSize}{font size for title. Default 12}

\item{keepGeneOrder}{force the resulting plot to use the order of the genes as specified. Default FALSE}

\item{includeSyn}{Set to TRUE to include silent variants. Default FALSE.}
}
\value{
Returns nothing. Just draws plot.
}
\description{
Draw two oncoplots side by side for cohort comparision.
}
\details{
Draws two oncoplots side by side to display difference between two cohorts.
}
\examples{
#' ##Primary and Relapse APL
primary.apl <- system.file("extdata", "APL_primary.maf.gz", package = "maftools")
relapse.apl <- system.file("extdata", "APL_relapse.maf.gz", package = "maftools")
##Read mafs
primary.apl <- read.maf(maf = primary.apl)
relapse.apl <- read.maf(maf = relapse.apl)
##Plot
coOncoplot(m1 = primary.apl, m2 = relapse.apl, m1Name = 'Primary APL', m2Name = 'Relapse APL')
dev.off()
}
