% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClinicalEnrichment.R
\name{clinicalEnrichment}
\alias{clinicalEnrichment}
\title{Performs mutational enrichment analysis for a given clinical feature.}
\usage{
clinicalEnrichment(maf, clinicalFeature = NULL, annotationDat = NULL,
  minMut = 5, useCNV = TRUE)
}
\arguments{
\item{maf}{\code{\link{MAF}} object}

\item{clinicalFeature}{columns names from `clinical.data` slot of \code{MAF} to be analysed for.}

\item{annotationDat}{If MAF file was read without clinical data, provide a custom \code{data.frame} or a tsv file with a column containing Tumor_Sample_Barcodes along with clinical features. Default NULL.}

\item{minMut}{Consider only genes with minimum this number of samples mutated. Default 5.}

\item{useCNV}{whether to include copy number events. Only applicable when MAF is read along with copy number data. Default TRUE if available.}
}
\value{
result list containing p-values
}
\description{
Performs paiwise and groupwise fisher exact tests to find differentially enriched genes for every factor within a clinical feature.
}
\examples{
laml.maf = system.file('extdata', 'tcga_laml.maf.gz', package = 'maftools')
laml.clin = system.file('extdata', 'tcga_laml_annot.tsv', package = 'maftools')
laml = read.maf(maf = laml.maf, clinicalData = laml.clin)
clinicalEnrichment(laml, 'FAB_classification')
}
\seealso{
\code{\link{plotEnrichmentResults}}
}
