% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annovarToMaf.R
\name{annovarToMaf}
\alias{annovarToMaf}
\title{Converts annovar annotations into MAF.}
\usage{
annovarToMaf(annovar, Center = NULL, refBuild = "hg19", tsbCol = NULL,
  table = "refGene", basename = NULL, sep = "\\t", MAFobj = FALSE,
  sampleAnno = NULL)
}
\arguments{
\item{annovar}{input annovar annotation file. Can be vector of multiple files.}

\item{Center}{Center field in MAF file will be filled with this value. Default NA.}

\item{refBuild}{NCBI_Build field in MAF file will be filled with this value. Default hg19.}

\item{tsbCol}{column name containing Tumor_Sample_Barcode or sample names in input file.}

\item{table}{reference table used for gene-based annotations. Can be 'ensGene' or 'refGene'. Default 'refGene'}

\item{basename}{If provided writes resulting MAF file to an output file.}

\item{sep}{field seperator for input file. Default tab seperated.}

\item{MAFobj}{If TRUE, returns results as an \code{\link{MAF}} object.}

\item{sampleAnno}{annotations associated with each sample/Tumor_Sample_Barcode in input annovar file. If provided it will be included in MAF object. Could be a text file or a data.frame. Ideally annotation would contain clinical data, survival information and other necessary features associated with samples. Default NULL.}
}
\value{
MAF table.
}
\description{
Converts variant annotations from Annovar into a basic MAF.
}
\details{
Annovar is one of the most widely used Variant Annotation tools in Genomics. Annovar output is generally in a tabular format with various annotation columns.
This function converts such annovar output files into MAF. This function requires that annovar was run with gene based annotation as a first operation, before including
any filter or region based annotations. Please be aware that this function performs no transcript prioritization.

e.g,
table_annovar.pl example/ex1.avinput humandb/ -buildver hg19 -out myanno -remove -protocol (\code{refGene}),cytoBand,dbnsfp30a -operation (\code{g}),r,f -nastring NA

This function mainly uses gene based annotations for processing, rest of the annotation columns from input file will be attached to the end of the resulting MAF.
}
\examples{
var.annovar <- system.file("extdata", "variants.hg19_multianno.txt", package = "maftools")
var.annovar.maf <- annovarToMaf(annovar = var.annovar, Center = 'CSI-NUS', refBuild = 'hg19',
tsbCol = 'Tumor_Sample_Barcode', table = 'ensGene')
}
\references{
Wang, K., Li, M. & Hakonarson, H. ANNOVAR: functional annotation of genetic variants from high-throughput sequencing data. Nucleic Acids Res 38, e164 (2010).
}
