#' Writes maf summaries to output tab-delimited text files.
#'
#' @param maf an \code{\link{MAF}} object generated by \code{\link{read.maf}}
#' @param basename basename for output file to be written.
#' @return None. Writes output as text files.
#' @seealso \code{\link{read.maf}}
#' @examples
#' laml.maf <- system.file("extdata", "tcga_laml.maf.gz", package = "maftools")
#' laml <- read.maf(maf = laml.maf)
#' write.mafSummary(maf = laml, basename = 'laml')
#'
#' @export

write.mafSummary = function(maf, basename = NULL){

  if(is.null(basename)){
    stop('Please provide a basename for output file.')
  }

  #write gene summary.
  write.table(x = maf@gene.summary, file = paste(basename,'_geneSummary.txt', sep=''), sep='\t', quote = FALSE, row.names = FALSE)
  #write sample summary.
  write.table(x = maf@variant.classification.summary, file = paste(basename,'_sampleSummary.txt', sep=''), sep='\t', quote = FALSE, row.names = FALSE)
  #write summary
  write.table(x = maf@summary,file = paste(basename,'_summary.txt', sep=''), sep='\t', quote = FALSE, row.names = FALSE)
  #write main maf
  data.table::fwrite(x = rbind(maf@data, maf@maf.silent, fill = TRUE), file = paste(basename,'_maftools.maf', sep=''), sep='\t', quote = FALSE, row.names = FALSE)
}
