% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmf_utils.R
\name{myNMF}
\alias{myNMF}
\title{Function to run NMF with different options}
\usage{
myNMF(data, prefix = "NMF", cluster = 3, nrun = 100, norm = F,
  ncores = 8, algorithm = "brunet", mode = "real", seed = 123211)
}
\arguments{
\item{data}{Input data sets}

\item{prefix}{Prefix for file output. Default is 'NMF'}

\item{cluster}{Estimated rank (clusters) in the data sets. Default is 3}

\item{algorithm}{Which algorithms for NMF? (bruent, lee, nsNMF, KL, Frobenius, offset, ls-nmf, pe-nmf, siNMF). Default is brunet}

\item{mode}{Which modules to run? (Estim or Real). Default is real}

\item{run}{How many runs to perform? Default is 100}
}
\description{
This function allows you to perform matrix factorization using Non-negative matrix factorization (NMF) method
User need to provide filtered/ordered gene expression data and client info (expinfo) files
Workflow ###
1 estimate how many clusters (k) ###
1.1 estim.r <- nmf(data, 2:10, nrun=100)
1.1 random shuffle the row (genes) for each column (sample) - estim.random.r
1.2 generate plot(estim.r), consensusmap(estim.r), plot(estim.r, estim.random.r)
2 After looking through the graph and decide k # This can be automated?
2.1 res <- nmf(data, k, nrun=100?)
2.2 compare the original.data and fitted.data (heatmap.2) # ignore this.
2.3 summary (res), summary(res, target=data), summary(res, class=assigned.subtypes)
2.4 plot basismap(res) and coefmap(res)
2.5 extract metagene-specific features
}
\examples{
myNMF(data, mode="estim", cluster=3, nrun=20)
}
\keyword{NMF}
\keyword{cluster}

