% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmf_utils.R
\name{iter_nmf}
\alias{iter_nmf}
\title{Run iterative NMF for K=2 until it cannot no longer separate samples}
\usage{
iter_nmf(rawdata, nrun = 10, round = 1, min.sample = 10, mad = 5000,
  silhouette = 0.95, w.silhouette = 0.7, w.min.sample = 10, ncores = 8)
}
\arguments{
\item{rawdata}{gene count table}

\item{nrun}{number of runs for each NMF}

\item{min.sample}{number of required minimum samples in each subclusters}

\item{mad}{number of top MAD genes}

\item{silhouette}{min required threshold for silhouette index after NMF run}
}
\description{
Run iterative NMF for K=2 until it cannot no longer separate samples
}
\examples{
iter_nmf(rawdata, nrun=10, mad=5000)
}
\keyword{NMF}
\keyword{iterative}

