#!/usr/bin/env python
from sys import argv
import pandas as pd
import numpy as np
from scipy.stats import ttest_ind

df = argv[1]
df_to_match = argv[2]

df = pd.read_csv(df, sep="\t", index_col=0)
df_to_match = pd.read_csv(df_to_match, sep="\t", index_col=0)

df_mean = df.mean(axis=1)
df_mean_to_match = df_to_match.mean(axis=1)

_,p = ttest_ind(np.log10(df_mean.values+1), np.log10(df_mean_to_match.values+1))

print "T-test, difference of means, p = %0.2e"%(p)