#!/usr/bin/env python
from Bio import SeqIO
from sys import argv
import re

fasta = argv[1]
pattern = argv[2]

# fasta = "/data/reddylab/tmp/tmp.rlSObpebeg"
# pattern = "CTCC[ACGT]GGAGA"

regex = re.compile(pattern)

with open(fasta, "r") as handle:
    for record in SeqIO.parse(handle, "fasta"):
        if regex.search(str(record.seq).upper()) or regex.search(str(record.reverse_complement().seq).upper()) :
            contains_pattern = 1
        else:
            contains_pattern = 0
        print "%s\t%s"%(record.id, contains_pattern)
                        