#!/usr/bin/env python
from collections import defaultdict
from sys import argv

fimo_in = argv[1]
out = argv[2]

fimo_d = defaultdict(dict)
motifs = set([])
with open(fimo_in, "r") as inf:
    header = next(inf)
    for line in inf:
        motif,seq_name,start,stop,strand,score,pval,qval,matched_seq = line.strip().split("\t")
        motifs.add(motif)
        if motif in fimo_d[seq_name]:
            if float(pval) < fimo_d[seq_name][motif]:
                fimo_d[seq_name][motif] = float(pval)
            else:
                pass
        else:
            fimo_d[seq_name][motif] = float(pval)

def sort_nicely( l ): 
    """ 
    Sort the given list in the way that humans expect. 
    """ 
    import re
    convert = lambda text: int(text) if text.isdigit() else text 
    alphanum_key = lambda key: [ convert(c) for c in re.split('([0-9]+)', key) ] 
    return(sorted( l, key=alphanum_key ))

motifs = sort_nicely(motifs)                      
with open(out, "w") as outf:
    outf.write("site\t" + "\t".join(motifs) + "\n")
    for seq_name in sort_nicely(fimo_d.keys()):
        best_pvals = [str(fimo_d[seq_name][motif]) if motif in fimo_d[seq_name] else "1" for motif in motifs]
        outf.write(seq_name + "\t" + "\t".join(best_pvals) + "\n")