#!/usr/bin/env python
import json
import argparse

parser = argparse.ArgumentParser(formatter_class=argparse.RawTextHelpFormatter, \
description="""

query_json_dict_by_keys.py

Given a json dictionary and some keys, print values to standard out.

""")

##################################################
# required arguments:

parser.add_argument("--json_dict", help="required, path to json dictionary", required=True)
parser.add_argument("--keys", help="""required, keys to dictionary where each listed
key is a further level in dictionary, e.g.: 
if json_dict == d and d['key1']['key2'] = 12,
then --json_dict d --keys key1 key2 will return 12""", nargs='+', required=True)

##################################################
args = parser.parse_args()

with open(args.json_dict, 'r') as f:
    json_dict = json.load(f)
    
ans = json_dict.copy()
for key in args.keys:
    ans = ans[key]

if type(ans) is list:
    print('\n'.join(ans))
else:
    print(ans)
 
