#!/usr/bin/env python
import pandas as pd
import numpy as np
from sys import argv

fimos = argv[1].split(",")
outs = argv[2].split(",")

# fimos = "fimo.GR.in.enhancers.best.txt,fimo.GR.in.distal_dhss.best.txt,fimo.GR.in.random_distal_dhss.best.txt".split(",")
# outs = "fimo.GR.in.enhancers.best.matched.txt,fimo.GR.in.distal_dhss.best.matched.txt,fimo.GR.in.random_distal_dhss.best.matched.txt".split(",")

fimo_dfs = []
for fimo in fimos:
    df = pd.read_csv(fimo, sep="\t", header=None, names=["site","pval","start","stop","strand","match"])
    fimo_dfs.append(df)

match_intersect = set([match for df in fimo_dfs for match in df['match']])
for df in fimo_dfs:
    match_intersect = match_intersect & set(df['match'])

fn = lambda obj: obj.loc[np.random.choice(obj.index),:]

for i,df in enumerate(fimo_dfs):
    df_sub = df[df['match'].isin(match_intersect)]
    df_sub = df_sub.groupby('match', as_index=False).apply(fn)
    df_sub = df_sub.sort_values('pval')
    df_sub.to_csv(outs[i], sep="\t", header=False, index=False)
    