#!/usr/bin/env python
from goatools.obo_parser import GODag, GraphEngines
from GGR import utils
from sys import argv

term = argv[1]
genes = argv[2]
mapping = argv[3]
obo_file = argv[4]
outfile = argv[5]

genes = utils.read_file_return_set(genes)
g = GODag(obo_file)

gene_to_IDs = {}
with open(mapping, "r") as f:
    for line in f:
        if len(line.split("\t")) > 1:
            gene,IDs = line.split("\t")
            gene_to_IDs[gene] = IDs.strip().split(";")
    
genes_with_term = []
for gene in genes:
    if gene not in gene_to_IDs: continue
    IDs = gene_to_IDs[gene]
    for ID in IDs:
        if ID == term:
            genes_with_term.append(gene)
            continue
        rec = g.query_term(term)
        all_parents = rec.get_all_parents()
        for parent in all_parents:
            if parent == term:
                genes_with_term.append(gene)
                continue

with open(outfile, "w") as f:
    f.write("\n".join(sorted(genes_with_term)) + "\n")