#!/usr/bin/env Rscript

suppressPackageStartupMessages(library("argparse"))
# create parser object
parser <- ArgumentParser()

# required args
parser$add_argument("-i", "--mat",
 help="Input matrix")
parser$add_argument("-r", "--rds",
 help="Input RDS")
parser$add_argument("-o", "--out",
 help="logFC")

# optional args
parser$add_argument("-s", "--sv",
 help="Input surrogate variable")
parser$add_argument("-p", "--prior_count", type="double", default=0.125,
 help="prior.count in glmFit, [default \"%(default)s\"]")

args <- parser$parse_args()

if (is.null(args$mat)){
    print("Please provide --mat")
    exit()
}
if (is.null(args$out)){
    print("Please provide --out")
    exit()
}
if (!is.null(args$ncis)){
    if (is.null(args$lib_sizes)){
        print("If --ncis provided, please provide --lib_sizes")
        exit()
    }
    if (is.null(args$ctrl_lib_sizes)){
        print("If --ncis provided, please provide --ctrl_lib_sizes")
        exit()
    }
}

##################################################

suppressPackageStartupMessages(library("edgeR"))

mat <- read.table(args$mat, header = T, row.names=1, sep='\t')
timepoint <- factor(sapply(strsplit(as.character(colnames(mat)), "_"), function(x) x[[1]]))

if (!is.null(args$sv)){
    sv <- as.matrix(read.table(args$sv, header = F, sep='\t'))
    model_design <- model.matrix(~timepoint+sv)
}else{
    model_design <- model.matrix(~timepoint)
}

# read y mat
y <- readRDS(args$rds)
logFC <- predFC(y, prior.count=args$prior_count, design=model_design)
if (!is.null(args$sv)){
    logFC <- logFC[,2:(qr(model_design)$rank-dim(sv)[2])]
    colnames(logFC) <- as.character(levels(timepoint)[2:(qr(model_design)$rank-dim(sv)[2])])
}else{
    logFC <- logFC[,2:(qr(model_design)$rank)]
    colnames(logFC) <- as.character(levels(timepoint)[2:qr(model_design)$rank])
}
# reorder results
logFC <- logFC[order(rownames(logFC)),]

# write results to table
write.table(file=args$out, as.data.frame(logFC, row.names=row.names(logFC)), sep="\t", quote=F, row.names=T, col.names=NA )
