#!/usr/bin/env python
from sys import argv
from collections import defaultdict

seqs_in = argv[1]
out = argv[2]

# seqs_in = "JunB.de_novo_motif_fimo.in.JunB.union.selected_reps.matches.quintile_5.txt"
# out = "JunB.de_novo_motif_fimo.in.JunB.union.selected_reps.matches.quintile_5.matrix.txt"

alphabet = ["A","C","G","T"]

count_dict = defaultdict(dict)
with open(seqs_in, "r") as inf:
    for line in inf:
        for i,letter in enumerate(line.strip()):
            if letter in count_dict[i+1]:
                count_dict[i+1][letter] += 1
            else:
                count_dict[i+1][letter] = 1

for pos in count_dict.keys():
    for letter in alphabet:
        if letter not in count_dict[pos]:
            count_dict[pos][letter]=0

with open(out, "w") as outf:
    outf.write("Pos\tA\tC\tG\tT\n")
    for Pos in sorted(count_dict):
        outf.write("%s\t%s\t%s\t%s\t%s\n"%(tuple([Pos] + [count_dict[Pos][letter] for letter in alphabet])))