#!/usr/bin/env python
import pandas as pd
from sys import argv

df = argv[1]
out = argv[2]

df = pd.read_csv(df, sep="\t", index_col=0)
df['beta'] = df.mean(axis=1)
df['beta_se'] = df.std(axis=1)
df = df.sort_values('beta', ascending=False)
df = df[['beta','beta_se']].T
df.to_csv(out, sep="\t", index=True)