#!/usr/bin/env python
from sys import argv
import numpy as np
from scipy.stats import norm

list1 = argv[1]
list2 = argv[2]

# list1 = "EP300.in.dex_hypersensitive_enhancers.log2CPM.t00.cut.txt"
# list2 = "EP300.in.dex_lowsensitive_enhancers.log2CPM.t00.cut.txt"

with open(list1, "r") as f:
    list1 = np.array([float(line.strip()) for line in f])

with open(list2, "r") as f:
    list2 = np.array([float(line.strip()) for line in f])

nboot = 1000
ratios = []
for boot in range(nboot):
    med1 = np.median(np.random.choice(list1, size=len(list1), replace=True))
    med2 = np.median(np.random.choice(list2, size=len(list2), replace=True))
    ratios.append(med1/med2)

mu, std = norm.fit(ratios)

print("low\tmedian\thigh")
print("%s\t%s\t%s"%(mu-std*1.96,
                   np.median(list1) / np.median(list2),
                   mu+std*1.96))