#!/usr/bin/env Rscript
##################################################
#  chipseeker_wrapper.R
#
##################################################
## Collect arguments
args <-commandArgs(TRUE)

## Default setting when no arguments passed
if (length(args) != 3 ){
  args <- c("--help")
}

## Help section
if("--help" %in% args) {
  cat("
      chipseeker_wrapper.R
 
      Usage:
      ./chipseeker_wrapper.R peaks TXDB location_annotation\n")
  q(save="no")
}

library(GenomicFeatures)
require(ChIPseeker)
library("GenomicRanges")
 
peaks = args[1]
txdb = args[2]
peak_anno_out = args[3]

# peaks = '/tmp/iter0_union_macs2bf'
# peak_anno_out = '/tmp/iter0_union_macs2bf.annot.txt'

peaks = read.table(peaks, sep='\t', header=FALSE, stringsAsFactors=FALSE)
colnames(peaks) = c('peak_chrom','peak_start','peak_end','peak_name')
peaks_gr <- with(peaks, GRanges(peak_chrom, IRanges(peak_start, peak_end), id=peak_name))

txdb <- loadDb(txdb)
peak_anno <- annotatePeak(peaks_gr, TxDb=txdb)

peak_anno_merge = merge(peaks, as.data.frame(peak_anno@anno@elementMetadata@listData), by.x='peak_name', by.y='id')
write.table(peak_anno_merge, file=peak_anno_out, quote=F, sep='\t', row.names=F)
