#!/usr/bin/env python
import matplotlib.pyplot as plt
from matplotlib import colors
import pandas as pd
import numpy as np
from sys import argv

fimo = argv[1]
outplot = argv[2]

fimo = pd.read_csv(fimo, sep="\t", header=None, names=["site","pval","start","stop","strand","match"])

cmap = colors.ListedColormap(['green','blue','orange','red'])
bounds=[0,1,2,3]
norm = colors.BoundaryNorm(bounds, cmap.N)

letter_to_num_d = {'A':0,'C':1,'G':2,'T':3}

mat = np.array([[letter_to_num_d[letter] for letter in list(match)] for match in fimo['match']])

plot_matrix(rm,cmap=cmap)

fig,ax = plt.subplots(figsize=(3,8))
ax.imshow(mat, interpolation='nearest', origin='upper', 
          aspect=0.1, cmap=cmap)
ax.set_xticks([])
ax.set_yticks([])
plt.tight_layout()
plt.savefig(outplot)
plt.savefig(outplot.replace(".png",".pdf"))
