#!/usr/bin/env python
import pandas as pd
import numpy as np
from sys import argv

pval_df = argv[1]
cutoff = float(argv[2])
out = argv[3]

# pval_df = "all.fimo.rsat_clustered_motifs.pvals.out"
# cutoff = 0.001
# out = "all.fimo.rsat_clustered_motifs.binary_0.001.out"

pval_df = pd.read_csv(pval_df, sep="\t", index_col=0)
pval_arr = np.array(pval_df)

pval_arr[np.array(pval_df) > cutoff] = 0
pval_arr[np.array(pval_df) <= cutoff] = 1

pval_df = pd.DataFrame(pval_arr, columns=pval_df.columns, index=pval_df.index)

pval_df.to_csv(out, sep="\t", index=True)
