#!/usr/bin/env python
import pandas as pd
from sklearn.decomposition import PCA
from sklearn.preprocessing import scale
from sys import argv

df = argv[1]
out = argv[2]
out_pcs = argv[3]

df = pd.read_csv(df, sep="\t", index_col=0)

X = scale(df)
pca = PCA()
pca.fit(X)
X_transformed = pca.fit_transform(X)

df_transformed = pd.DataFrame(X_transformed,
                              index=df.index,
                              columns=['PC%s'%(i+1) for i in range(X.shape[1])])
df_components = pd.DataFrame(pca.components_,
                              index=['PC%s'%(i+1) for i in range(X.shape[1])],
                              columns=df.columns)

df_transformed.to_csv(out, sep="\t")
df_components.to_csv(out_pcs, sep="\t")